// Changement 1
package models.org.letouilleur.demo;


import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.*;

// Changement 2
import play.db.jpa.*;
import java.util.*;

@Entity
@Table(name = "MICRO_MARKET")
// Changement 3
public class MicroMarket extends JPASupport implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Basic(optional = false)
    @Column(name = "ZIP_CODE")
    public String zipCode;
    @Column(name = "RADIUS")
    public Double radius;
    @Column(name = "AREA_LENGTH")
    public Double areaLength;
    @Column(name = "AREA_WIDTH")
    public Double areaWidth;

    public MicroMarket() {
    }

    public MicroMarket(String zipCode) {
        this.zipCode = zipCode;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (zipCode != null ? zipCode.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof MicroMarket)) {
            return false;
        }
        MicroMarket other = (MicroMarket) object;
        if ((this.zipCode == null && other.zipCode != null) || (this.zipCode != null && !this.zipCode.equals(other.zipCode))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "org.letouilleur.demo.MicroMarket[zipCode=" + zipCode + "]";
    }

	public List<MicroMarket> findByZipCode(String zipCode, int page, int length) {
		return  find("from MicroMarket m where m.zipcode like :p").bind("p",zipCode).fetch(page,length);
	}
}
